
from dataclasses import dataclass
import math

@dataclass
class SRBudget:
    sum_dtau: float = 0.0
    sum_dt: float = 0.0
    sum_dx: float = 0.0

class GammaCalc:
    @staticmethod
    def alpha(sum_dx, c, sum_dt):
        if c<=0 or sum_dt<=0: return 0.0
        return abs(sum_dx) / (c * sum_dt)

    @staticmethod
    def gamma(sum_dtau, sum_dt):
        if sum_dtau<=0: return 0.0
        return sum_dt / sum_dtau

    @staticmethod
    def gamma_theory(alpha):
        if alpha>=1.0:
            return float("inf")
        return 1.0 / math.sqrt(max(1e-12, 1.0 - alpha*alpha))
